/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import jclass.bwt.JCSerializable;
import jclass.chart.Changeable;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Chartable;
import jclass.chart.DataInterpretation;
import jclass.chart.DoubleCoord;
import jclass.chart.EditableChartable;
import jclass.chart.JCAxis;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChart;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataCoord;
import jclass.chart.JCDataIndex;
import jclass.chart.JCPieChartFormat;
import jclass.chart.MinMax;
import jclass.chart.PieChartDraw;
import jclass.util.JCVector;

public class ChartDataView
implements Observer,
Changeable,
JCSerializable {
    protected JCVector series = new JCVector();
    public static final int PICK_FOCUS_LOCAL = -1;
    public static final int PICK_FOCUS_XY = 0;
    public static final int PICK_FOCUS_X = 1;
    public static final int PICK_FOCUS_Y = 2;
    private double[] xvalues;
    boolean isBatched = false;
    double holeValue = Double.MAX_VALUE;
    int chartType = 0;
    String name;
    int drawingOrder = -1;
    Chartable dataSource;
    DataInterpretation dataInterpretation;
    JCAxis xaxis;
    JCAxis yaxis;
    JCVector pointLabels = new JCVector();
    JCBarChartFormat barChartFormat;
    JCPieChartFormat pieChartFormat;
    private transient Object transientData;
    boolean isInverted = false;
    int pickFocus = 0;
    boolean isShowingInLegend = true;
    int previousXAxisAnnotationMethod;
    private JCVector styles = new JCVector();
    boolean changed = true;
    boolean allowPick = true;
    JCChart chart;
    MinMax xLimits;
    MinMax yLimits;
    static int dataViewNum;

    ChartDataView(JCChart jCChart) {
        this.setChartType(0);
        this.setParent(jCChart);
        this.name = "DataView #" + ++dataViewNum;
    }

    public ChartDataView() {
        this.setChartType(0);
        this.name = "DataView #" + ++dataViewNum;
    }

    void setParent(JCChart jCChart) {
        this.chart = jCChart;
        if (this.chart != null && this.chart.chartArea != null) {
            if (this.xaxis == null || !this.chart.chartArea.xaxes.contains(this.xaxis)) {
                this.xaxis = this.chart.chartArea.getXAxis(0);
            }
            if (this.yaxis == null || !this.chart.chartArea.yaxes.contains(this.yaxis)) {
                this.yaxis = this.chart.chartArea.getYAxis(0);
            }
        }
        this.setChanged(true, false);
    }

    void draw(Graphics graphics) {
    }

    boolean editPoint(ChartDataViewSeries chartDataViewSeries, int n, double d) {
        if (this.dataSource == null) {
            return true;
        }
        if (!(this.dataSource instanceof EditableChartable)) {
            return false;
        }
        int n2 = -1;
        n2 = this.series.indexOf(chartDataViewSeries);
        if (n2 == -1) {
            throw new RuntimeException("Bad row in editPoint!");
        }
        return this.dataInterpretation.editPoint(n2, n, d);
    }

    public void update(Observable observable, Object object) {
        if (!(object instanceof ChartDataModelUpdate)) {
            return;
        }
        ChartDataModelUpdate chartDataModelUpdate = (ChartDataModelUpdate)object;
        switch (chartDataModelUpdate.message) {
            case 0: {
                this.dataInterpretation.changeValue(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 1: {
                this.dataInterpretation.addValue(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 2: {
                this.dataInterpretation.removeValue(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 3: {
                this.dataInterpretation.changeRow(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 4: {
                this.dataInterpretation.addRow(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 5: {
                this.dataInterpretation.removeRow(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 6: {
                this.dataInterpretation.changeColumn(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 7: {
                this.dataInterpretation.addColumn(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 8: {
                this.dataInterpretation.removeColumn(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 9: {
                this.dataInterpretation.changePointLabel(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 10: {
                this.dataInterpretation.changeSeriesName(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 11: {
                this.dataInterpretation.changeSeriesLabel(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 12: {
                boolean bl = this.getIsBatched();
                this.setIsBatched(true);
                this.dataInterpretation.reset(chartDataModelUpdate.row, chartDataModelUpdate.column);
                this.setIsBatched(bl);
                return;
            }
        }
        this.setChanged(true);
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    public synchronized void setHoleValue(double d) {
        this.holeValue = d;
    }

    public boolean getIsBatched() {
        return this.isBatched;
    }

    public synchronized void setIsBatched(boolean bl) {
        if (this.isBatched == bl) {
            return;
        }
        this.isBatched = bl;
        if (!this.isBatched) {
            this.propagateChange();
        }
    }

    public int getChartType() {
        return this.chartType;
    }

    public synchronized void setChartType(int n) {
        if (this.chartType == n) {
            return;
        }
        if (this.xaxis != null) {
            this.xaxis.annotationMethod = this.previousXAxisAnnotationMethod;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw new IllegalArgumentException("Currently unsupported chart type");
            }
            default: {
                throw new IllegalArgumentException("Invalid chart type");
            }
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: 
        }
        switch (this.chartType) {
            case 11: {
                if (this.yaxis != null) {
                    this.yaxis.isShowing = true;
                    this.yaxis.setChanged(true, false);
                }
                if (this.xaxis == null) break;
                this.xaxis.isShowing = true;
                this.xaxis.setChanged(true, false);
                break;
            }
            case 9: 
            case 10: {
                if (this.xaxis == null) break;
                this.previousXAxisAnnotationMethod = this.xaxis.annotationMethod;
                this.xaxis.annotationMethod = 0;
                this.xaxis.setChanged(true, false);
                break;
            }
        }
        this.chartType = n;
        if (this.chartType == 11 && this.pieChartFormat == null) {
            this.pieChartFormat = new JCPieChartFormat(this);
        }
        if ((this.chartType == 9 || this.chartType == 10) && this.barChartFormat == null) {
            this.barChartFormat = new JCBarChartFormat(this);
        }
        switch (this.chartType) {
            case 9: 
            case 10: {
                if (this.yaxis == null || this.xaxis == null) break;
                this.previousXAxisAnnotationMethod = this.xaxis.annotationMethod;
                this.xaxis.placementAxis = this.yaxis;
                this.xaxis.annotationMethod = 3;
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.setPlacement(5);
                } else {
                    this.xaxis.setChanged(true, false);
                }
                if (!this.yaxis.getOriginPlacementIsDefault()) break;
                this.yaxis.setOriginPlacement(3);
                break;
            }
            case 8: {
                if (this.yaxis == null || this.xaxis == null) break;
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    this.yaxis.setChanged(true, false);
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.placementAxis = this.yaxis;
                this.xaxis.setChanged(true, false);
                break;
            }
            case 11: {
                if (this.yaxis != null) {
                    this.yaxis.isShowing = false;
                    this.yaxis.setChanged(true, false);
                }
                if (this.xaxis == null) break;
                this.xaxis.isShowing = false;
                this.xaxis.setChanged(true, false);
                break;
            }
        }
        if (this.chart != null) {
            this.chart.chartArea.removeDrawable(this);
        }
        this.setChanged(true);
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        if (this.name != null && this.name.equals(string)) {
            return;
        }
        this.name = string;
        this.setChanged(true);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public synchronized void setDrawingOrder(int n) {
        if (n < 0 || this.chart != null && n >= this.chart.data.size()) {
            throw new IllegalArgumentException("DrawingOrder property for ChartDataView is out of range");
        }
        this.drawingOrder = n;
        this.setChanged(true);
    }

    public Chartable getDataSource() {
        return this.dataSource;
    }

    public synchronized void setDataSource(Chartable chartable) {
        int n;
        this.dataSource = chartable;
        if (this.dataSource == null) {
            return;
        }
        this.dataInterpretation = DataInterpretation.getData(this, chartable);
        String[] stringArray = chartable.getPointLabels();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                this.pointLabels.addElement(stringArray[n]);
                ++n;
            }
        }
        n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
            chartDataViewSeries.name = chartable.getSeriesName(n);
            chartDataViewSeries.label = chartable.getSeriesLabel(n);
            ++n;
        }
        this.name = chartable.getName();
        if (chartable instanceof Observable) {
            ((Observable)((Object)chartable)).addObserver(this);
        }
        if (!(this.dataSource instanceof EditableChartable) && !(this.dataSource instanceof Observable)) {
            this.dataSource = null;
        }
        this.setChanged(true);
    }

    public String getPointLabel(int n) {
        if (n < 0 || n >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        return (String)this.pointLabels.elementAt(n);
    }

    public synchronized void setPointLabel(int n, String string) {
        if (n < 0 || n >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        this.pointLabels.setElementAt(n, string);
        this.setChanged(true);
    }

    public String[] getPointLabels() {
        if (this.pointLabels == null || this.pointLabels.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.pointLabels.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.pointLabels.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public int getNumPointLabels() {
        return this.pointLabels.size();
    }

    public synchronized void setPointLabels(String[] stringArray) {
        this.pointLabels = new JCVector(stringArray);
        this.setChanged(true);
    }

    public ChartDataViewSeries[] getSeries() {
        ChartDataViewSeries[] chartDataViewSeriesArray = new ChartDataViewSeries[this.series.size()];
        int n = 0;
        while (n < this.series.size()) {
            chartDataViewSeriesArray[n] = (ChartDataViewSeries)this.series.elementAt(n);
            ++n;
        }
        return chartDataViewSeriesArray;
    }

    public ChartDataViewSeries getSeries(int n) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException("Invalid ChartDataViewSeries index.");
        }
        return (ChartDataViewSeries)this.series.elementAt(n);
    }

    public synchronized void setSeries(ChartDataViewSeries[] chartDataViewSeriesArray) {
        this.series = new JCVector(chartDataViewSeriesArray);
        this.setChanged(true);
    }

    public synchronized void setSeries(int n, ChartDataViewSeries chartDataViewSeries) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException("Invalid ChartDataViewSeries index.");
        }
        this.series.setElementAt(n, chartDataViewSeries);
        this.setChanged(true);
    }

    public ChartDataViewSeries addSeries(int n) {
        ChartDataViewSeries chartDataViewSeries = null;
        if (n < 0) {
            n = 0;
        }
        if (n > this.series.size()) {
            n = this.series.size();
        }
        chartDataViewSeries = new ChartDataViewSeries();
        chartDataViewSeries.init(null, null, this);
        chartDataViewSeries.setDrawingOrder(n);
        this.series.insertElementAt(chartDataViewSeries, n);
        this.setChanged(true);
        return chartDataViewSeries;
    }

    public synchronized void addSeries(ChartDataViewSeries chartDataViewSeries) {
        chartDataViewSeries.setDrawingOrder(this.series.size());
        this.series.addElement(chartDataViewSeries);
        this.setChanged(true);
    }

    public synchronized void removeSeries(int n) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException("Invalid ChartDataViewSeries index");
        }
        this.series.removeElementAt(n);
        this.setChanged(true);
    }

    public int getSeriesIndex(String string) {
        try {
            int n = 0;
            while (n < this.series.size()) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
                if (string.equals(chartDataViewSeries.getName())) {
                    return n;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    public int getSeriesIndex(ChartDataViewSeries chartDataViewSeries) {
        return this.series.indexOf(chartDataViewSeries);
    }

    public JCPieChartFormat getPieChartFormat() {
        if (this.pieChartFormat == null) {
            this.pieChartFormat = new JCPieChartFormat(this);
        }
        return this.pieChartFormat;
    }

    public JCBarChartFormat getBarChartFormat() {
        if (this.barChartFormat == null) {
            this.barChartFormat = new JCBarChartFormat(this);
        }
        return this.barChartFormat;
    }

    public JCAxis getXAxis() {
        return this.xaxis;
    }

    public synchronized void setXAxis(JCAxis jCAxis) {
        this.xaxis = jCAxis;
    }

    public JCAxis getYAxis() {
        return this.yaxis;
    }

    public synchronized void setYAxis(JCAxis jCAxis) {
        this.yaxis = jCAxis;
    }

    public JCDataCoord map(int n, int n2) {
        Point point = this.chart.chartArea.location();
        Rectangle rectangle = this.chart.chartArea.getDrawingArea();
        n = n - point.x - rectangle.x;
        n2 = n2 - point.y - rectangle.y;
        JCDataCoord jCDataCoord = new JCDataCoord(this.holeValue, this.holeValue);
        if (this.xaxis != null) {
            jCDataCoord.x = this.xaxis.toData(n);
        }
        if (this.yaxis != null) {
            jCDataCoord.y = this.yaxis.toData(n2);
        }
        return jCDataCoord;
    }

    public Point unmap(double d, double d2) {
        Point point = this.chart.chartArea.location();
        Rectangle rectangle = this.chart.chartArea.getDrawingArea();
        Point point2 = new Point(point.x + rectangle.x, point.y + rectangle.y);
        if (this.xaxis != null) {
            point2.x += this.xaxis.toPixel(d);
        }
        if (this.yaxis != null) {
            point2.y += this.yaxis.toPixel(d2);
        }
        return point2;
    }

    public JCDataCoord coordToDataCoord(int n, int n2) {
        return this.map(n, n2);
    }

    public Point dataCoordToCoord(double d, double d2) {
        return this.unmap(d, d2);
    }

    public Point dataIndexToCoord(JCDataIndex jCDataIndex) {
        Point point = this.chart.unpick(this, jCDataIndex.point, jCDataIndex.seriesIndex);
        if (point != null) {
            Point point2 = this.chart.chartArea.location();
            point.x += point2.x;
            point.y += point2.y;
        }
        return point;
    }

    public JCDataIndex coordToDataIndex(int n, int n2, int n3) {
        Point point = this.chart.chartArea.location();
        return this.chart.chartArea.pick(new Point(n - point.x, n2 - point.y), this, n3);
    }

    public int getNumSeries() {
        if (this.series == null) {
            return 0;
        }
        return this.series.size();
    }

    double[] toDoubleArray(Vector vector) {
        if (vector == null || vector.size() <= 0) {
            return null;
        }
        double[] dArray = new double[vector.size()];
        int n = 0;
        while (n < dArray.length) {
            Object e = vector.elementAt(n);
            dArray[n] = e == null ? this.holeValue : (e instanceof Number ? ((Number)e).doubleValue() : (e instanceof String ? Double.valueOf((String)e) : this.holeValue));
            ++n;
        }
        return dArray;
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            return "Unnamed DataView";
        }
        return string;
    }

    void calcXMinMax(MinMax minMax) {
        double d = this.xaxis.step;
        this.xaxis.step = Double.MAX_VALUE;
        int n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
            if (chartDataViewSeries.isIncluded) {
                chartDataViewSeries.getXMinMax(minMax);
                chartDataViewSeries.calcStep(this.xaxis);
            }
            ++n;
        }
        if (this.xaxis.step == Double.MAX_VALUE) {
            this.xaxis.step = d;
        }
    }

    void calcYMinMax(MinMax minMax) {
        int n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
            if (chartDataViewSeries.isIncluded) {
                chartDataViewSeries.getYMinMax(minMax);
            }
            ++n;
        }
    }

    private void calcYMinMaxOfTotals(MinMax minMax) {
        Point point = this.getFirstLast();
        if (point == null) {
            return;
        }
        int n = this.series.size();
        MinMax minMax2 = new MinMax();
        int n2 = point.x;
        while (n2 <= point.y) {
            MinMax minMax3 = new MinMax(0.0, 0.0);
            int n3 = 0;
            while (n3 < n) {
                double d;
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n3);
                if (chartDataViewSeries.isIncluded && (d = chartDataViewSeries.getY(n2)) != this.holeValue) {
                    if (d >= 0.0) {
                        minMax3.max += d;
                    } else {
                        minMax3.min += d;
                    }
                }
                ++n3;
            }
            minMax2.union(minMax3);
            ++n2;
        }
        minMax.union(minMax2);
    }

    void getDataBounds(MinMax minMax, MinMax minMax2) {
        boolean bl = this.chartType == 2;
        boolean bl2 = this.chartType == 3 || this.chartType == 4;
        boolean bl3 = bl || bl2;
        this.calcXMinMax(minMax);
        this.calcYMinMax(minMax2);
        if (!this.xaxis.min.isDefault && this.xaxis.min.value > minMax.min || bl3) {
            minMax.min = this.xaxis.min.value;
        }
        if (!this.xaxis.max.isDefault && this.xaxis.max.value < minMax.max || bl3) {
            minMax.max = this.xaxis.max.value;
        }
        if (!this.yaxis.min.isDefault && this.yaxis.min.value > minMax2.min || bl3) {
            minMax2.min = this.yaxis.min.value;
        }
        if (bl && minMax2.min < 0.0) {
            if (JCChartUtil.abs(minMax2.min) > minMax2.max) {
                minMax2.max = JCChartUtil.abs(minMax2.min);
            }
            minMax2.min = 0.0;
        }
        if (!this.yaxis.max.isDefault && this.yaxis.max.value < minMax2.max || bl3) {
            minMax2.max = this.yaxis.max.value;
        }
    }

    /*
     * Unable to fully structure code
     */
    DoubleCoord getOrigin(MinMax var1_1, MinMax var2_2, boolean var3_3) {
        block22: {
            block21: {
                block20: {
                    block18: {
                        block19: {
                            var4_4 = new DoubleCoord(var1_1.min, var2_2.min);
                            if (!var3_3) {
                                return var4_4;
                            }
                            var5_5 = this.chart.getChartArea().angleUnit;
                            if (!this.xaxis.origin.isDefault) break block18;
                            if (this.chartType != 2 && this.chartType != 3 && this.chartType != 4) break block19;
                            switch (var5_5) {
                                case 1: {
                                    var4_4.x = 90.0;
                                    ** GOTO lbl37
                                }
                                case 2: {
                                    var4_4.x = 1.5707963267948966;
                                    ** GOTO lbl37
                                }
                                case 3: {
                                    var4_4.x = 100.0;
                                    ** GOTO lbl37
                                }
                                default: {
                                    if (this.chartType != 10) break block20;
                                }
                            }
                        }
                        switch (this.xaxis.originPlacement.value) {
                            case 3: {
                                var4_4.x = 0.0;
                                ** GOTO lbl37
                            }
                            case 1: {
                                var4_4.x = var1_1.min;
                                ** GOTO lbl37
                            }
                            case 2: {
                                var4_4.x = var1_1.max;
                                ** GOTO lbl37
                            }
                            case 0: {
                                var4_4.x = var1_1.min <= 0.0 && var1_1.max >= 0.0 ? 0.0 : var1_1.min;
                                ** GOTO lbl37
                            }
                            default: {
                                if (this.chartType != 10) break block20;
                            }
                        }
                    }
                    var4_4.x = JCChartUtil.boundAngle(var5_5, this.xaxis.origin.value);
lbl37:
                    // 8 sources

                    if (this.chartType != 10) break block20;
                    var4_4.y = this.yaxis.isLogarithmic ? JCChartUtil.max(var2_2.min, 0.0) : 0.0;
                    ** GOTO lbl63
                }
                if (this.chartType != 2 && this.chartType != 3 && this.chartType != 4) break block21;
                var4_4.y = this.yaxis.isReversed ? var2_2.min : var2_2.max;
                ** GOTO lbl63
            }
            if (!this.yaxis.origin.isDefault) break block22;
            switch (this.yaxis.originPlacement.value) {
                case 3: {
                    var4_4.y = 0.0;
                    ** GOTO lbl63
                }
                case 1: {
                    var4_4.y = var2_2.min;
                    ** GOTO lbl63
                }
                case 2: {
                    var4_4.y = var2_2.max;
                    ** GOTO lbl63
                }
                case 0: {
                    var4_4.y = !(this.chartType != 9 && this.chartType != 8 || this.yaxis.isLogarithmic) ? 0.0 : (var2_2.min <= 0.0 && var2_2.max >= 0.0 ? 0.0 : var2_2.min);
                    ** GOTO lbl63
                }
                default: {
                    return var4_4;
                }
            }
        }
        var4_4.y = this.yaxis.origin.value;
lbl63:
        // 7 sources

        return var4_4;
    }

    void clearLimits() {
        if (this.xaxis != null) {
            this.xaxis.clearLimits();
        }
        if (this.yaxis != null) {
            this.yaxis.clearLimits();
        }
        this.xLimits = null;
        this.yLimits = null;
    }

    void calcLimits() {
        if (this.xaxis != null) {
            this.xLimits = new MinMax();
            this.calcXMinMax(this.xLimits);
            this.xaxis.setLimits(this.xLimits);
        }
        if (this.yaxis != null) {
            this.yLimits = new MinMax();
            if (this.chartType == 10) {
                if (this.barChartFormat.get100Percent()) {
                    this.yLimits.max = 100.0;
                    this.yLimits.min = -100.0;
                } else {
                    this.calcYMinMaxOfTotals(this.yLimits);
                }
            } else {
                this.calcYMinMax(this.yLimits);
            }
            this.yaxis.setLimits(this.yLimits);
        }
    }

    public MinMax getXLimits() {
        return this.xLimits;
    }

    public MinMax getYLimits() {
        return this.yLimits;
    }

    void getDataBoundValues(MinMax minMax, MinMax minMax2) {
        if (this.xLimits != null) {
            minMax.reset(this.xLimits);
        }
        if (this.yLimits != null) {
            minMax2.reset(this.yLimits);
        }
    }

    public boolean isChanged() {
        return this.getChanged();
    }

    public boolean getChanged() {
        return this.changed;
    }

    public synchronized void setChanged(boolean bl) {
        if (this.changed == bl) {
            return;
        }
        this.changed = bl;
        if (!this.changed) {
            return;
        }
        this.markAsChanged();
        this.propagateChange();
    }

    private void propagateChange() {
        if (!this.changed) {
            return;
        }
        if (this.getIsBatched()) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.chart.getIsBatched()) {
            return;
        }
        this.chart.update();
    }

    private void markAsChanged() {
        if (this.xaxis != null) {
            this.xaxis.setChanged(true, false);
        }
        if (this.yaxis != null) {
            this.yaxis.setChanged(true, false);
        }
        if (this.chart != null && this.chart.chartArea != null) {
            this.chart.chartArea.setChanged(true, false);
        }
        if (this.chart != null && this.chart.legend != null) {
            this.chart.legend.setChanged(true, false);
        }
    }

    public void setChanged(boolean bl, boolean bl2) {
        if (this.changed == bl) {
            return;
        }
        if (bl2) {
            this.setChanged(bl);
            return;
        }
        this.changed = bl;
        if (this.changed) {
            this.markAsChanged();
        }
    }

    public Point getFirstLast() {
        if (this.series == null) {
            return null;
        }
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n4);
            if (chartDataViewSeries.isShowing) {
                int n5;
                if (n < chartDataViewSeries.getFirstPoint()) {
                    n = chartDataViewSeries.getFirstPoint();
                }
                if (n2 > chartDataViewSeries.getLastPoint()) {
                    n2 = chartDataViewSeries.getLastPoint();
                }
                if (n3 > (n5 = chartDataViewSeries.maxIndex())) {
                    n3 = n5;
                }
            }
            ++n4;
        }
        if (n3 == Integer.MAX_VALUE) {
            return null;
        }
        if (n > n3) {
            return null;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            return null;
        }
        return new Point(n, n2);
    }

    public int getVisibleDataSeries() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n2);
            if (chartDataViewSeries.isShowing) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public synchronized void calcTransientData() {
        PieChartDraw pieChartDraw;
        if (this.getChartType() == 11 && (pieChartDraw = (PieChartDraw)this.chart.chartArea.getDrawable(this)) != null) {
            pieChartDraw.calcTransientData();
        }
    }

    public synchronized void setIsInverted(boolean bl) {
        if (this.isInverted == bl) {
            return;
        }
        this.isInverted = bl;
        if (this.xaxis != null) {
            this.xaxis.isVertical = bl;
        }
        if (this.yaxis != null) {
            this.yaxis.isVertical = !bl;
        }
        this.setChanged(true);
    }

    public boolean getIsInverted() {
        return this.isInverted;
    }

    public synchronized void setPickFocus(int n) {
        this.pickFocus = n;
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    public boolean getIsShowingInLegend() {
        return this.isShowingInLegend;
    }

    public synchronized void setIsShowingInLegend(boolean bl) {
        if (bl == this.isShowingInLegend) {
            return;
        }
        this.isShowingInLegend = bl;
        this.setChanged(true);
    }

    public synchronized void setChartStyle(int n, JCChartStyle jCChartStyle) {
        if (n < 0 || n > this.styles.size()) {
            throw new IllegalArgumentException("Invalid ChartStyle index in ChartDataView.");
        }
        if (n < this.styles.size()) {
            this.styles.setElementAt(jCChartStyle, n);
        } else {
            this.styles.insertElementAt(jCChartStyle, n);
        }
        this.setChanged(true);
    }

    public JCChartStyle getChartStyle(int n) {
        Object object;
        if (n < 0) {
            throw new IllegalArgumentException("ChartStyle index must be positive");
        }
        if (n >= this.styles.size()) {
            while (n >= this.styles.size()) {
                this.styles.addElement(null);
            }
        }
        if ((object = this.styles.elementAt(n)) == null) {
            object = JCChartStyle.makeDefault(this.chart);
            this.styles.setElementAt(object, n);
        }
        return (JCChartStyle)object;
    }

    public JCChartStyle[] getChartStyle() {
        if (this.styles == null || this.styles.size() == 0) {
            return null;
        }
        JCChartStyle[] jCChartStyleArray = new JCChartStyle[this.styles.size()];
        int n = 0;
        while (n < jCChartStyleArray.length) {
            jCChartStyleArray[n] = (JCChartStyle)this.styles.elementAt(n);
            ++n;
        }
        return jCChartStyleArray;
    }

    public synchronized void setChartStyle(JCChartStyle[] jCChartStyleArray) {
        this.styles = new JCVector();
        if (jCChartStyleArray == null) {
            return;
        }
        int n = 0;
        while (n < jCChartStyleArray.length) {
            this.styles.setElementAt(n, jCChartStyleArray[n]);
            ++n;
        }
    }

    double[] getX() {
        return this.xvalues;
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.dataSource != null && this.dataSource instanceof Observable) {
                ((Observable)((Object)this.dataSource)).addObserver(this);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    Object getTransientData() {
        return this.transientData;
    }

    void setTransientData(Object object) {
        this.transientData = object;
        if (this.chart != null && this.chart.legend != null) {
            this.chart.legend.setChanged(true, false);
        }
    }
}

